
<?php $__env->startSection('title','კომენტარები'); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h1 class="mt-4">კომენტარები</h1>
    
    <div class="row">
        
        <?php if(Session::has('result')): ?>
        <div class="col-md-12">
            <div class="alert alert-<?php echo e(Session::get('result') ? 'success' : 'danger'); ?>">
                ოპერაცია <?php echo e(Session::get('result') ? 'წარმატებით' : 'წარუმატებლად'); ?> დასრულდა
            </div>
        </div>
        <?php endif; ?>
        
        <div class="col-md-12">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">გამოქვეყნდეს</th>
                        <th scope="col">ავტორი</th>
                        <th scope="col">კომენტარი</th>
                        <th scope="col">სიახლე</th>
                        <th scope="col">თარიღი</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th scope="row"><?php echo e(++$key); ?></th>
                            <td>
                                <input type="checkbox" class="confirm-checkbox" data-id="<?php echo e($item->id); ?>" <?php echo e($item->confirmed ? 'checked' : ''); ?>>
                            </td>
                            <td><?php echo e($item->email); ?></td>
                            <td><?php echo e($item->comment); ?></td>
                            <td><?php echo e($item->article); ?></td>
                            <td><?php echo e($item->created_at); ?></td>
                            <td>
                                <form action="<?php echo e(route('comments.destroy', $item->id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="_method" value="delete">
                                    <a href="#!" class="btn btn-sm btn-danger btn-destroy">
                                        <i class="fa fa-trash"></i> 
                                    </a>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    
    

    $('.confirm-checkbox').change(function() 
    {
        let id = $(this).data('id');

        $.ajax({
            url: "/admin/comments/confirm",
            type: 'post',
            dataType: 'json',
            data: {id: id, _token : '<?php echo e(csrf_token()); ?>'}
        }).done(function (data){

            alert(data.message);

        });
    });
    
    $('.btn-destroy').on('click', function(){
        
        if(confirm('დარწმუნებული ხართ ?'))
        {
            $(this).parent('form').submit();         
        }
        
    });
    
</script>
<?php $__env->stopSection(); ?>

                
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\blog\resources\views/admin/comments/index.blade.php ENDPATH**/ ?>