<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <title><?php echo $__env->yieldContent('title'); ?></title>
        <!-- Font Awesome icons (free version)-->
        <script src="https://use.fontawesome.com/releases/v5.15.3/js/all.js" crossorigin="anonymous"></script>
        <!-- Google fonts-->
        <link href="https://fonts.googleapis.com/css?family=Lora:400,700,400italic,700italic" rel="stylesheet" type="text/css" />
        <link href="https://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,300,600,700,800" rel="stylesheet" type="text/css" />
        <!-- Core theme CSS (includes Bootstrap)-->
        <link href="<?php echo e(asset('assets/front/css/styles.css')); ?>" rel="stylesheet" />
    </head>
    <body>
        
        <!-- მენიუ -->
        <nav class="navbar navbar-expand-lg navbar-light" id="mainNav">
            <div class="container px-4 px-lg-5">
                <a class="navbar-brand" href="<?php echo e(route('index')); ?>">Start Bootstrap</a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                    Menu
                    <i class="fas fa-bars"></i>
                </button>
                <div class="collapse navbar-collapse" id="navbarResponsive">
                    <ul class="navbar-nav ms-auto py-4 py-lg-0">
                        <li class="nav-item">
                            <a class="nav-link px-lg-3 py-3 py-lg-4" href="
                                <?php echo e(route('index')); ?>"><?php echo app('translator')->get('menu.index'); ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link px-lg-3 py-3 py-lg-4" href="contact.html">
                                <?php echo app('translator')->get('menu.contact'); ?>
                            </a>
                        </li>
                        <?php if(auth()->guard()->check()): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('dashboard')); ?>" class="nav-link px-lg-3 py-3 py-lg-4">
                                    <?php echo app('translator')->get('site.dashboard'); ?>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="#!" 
                                   class="nav-link px-lg-3 py-3 py-lg-4" 
                                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                                >
                                    <?php echo app('translator')->get('site.logout'); ?>
                                </a>
                            </li>

                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                <?php echo csrf_field(); ?>
                            </form>

                        <?php else: ?>
                            <li class="nav-item">
                                <a class="nav-link px-lg-3 py-3 py-lg-4" href="<?php echo e(route('register')); ?>">
                                    <?php echo app('translator')->get('site.register'); ?>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link px-lg-3 py-3 py-lg-4" href="<?php echo e(route('login')); ?>">
                                    <?php echo app('translator')->get('site.login'); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                
                        <!-- ენების გადამრთველი -->
                        <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item">
                                <a  href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>" class="nav-link px-lg-3 py-3 py-lg-4">
                                    <?php echo e(strtoupper(mb_substr($properties['name'], 0, 2))); ?> 
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </nav>
        <!-- /მენიუ -->
        
        <!-- საიტის ქუდი -->
        <?php
            $articles_page = Route::current()->getName() == 'article' ? true : false;
        ?>
        <header class="masthead" style="background-image: url('<?php echo e($articles_page ? $article->image : asset('assets/front/assets/img/home-bg.jpg')); ?>')">
            <div class="container position-relative px-4 px-lg-5">
                <iv class="row gx-4 gx-lg-5 justify-content-center">
                    <div class="col-md-10 col-lg-8 col-xl-7">
                        <div class="site-heading">
                            <h1><?php echo e($articles_page ? $article->title : 'Clean Blog'); ?>

                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- /საიტის ქუდი -->
        
        <!-- ძირითადი შიგთავსი -->
        <?php echo $__env->yieldContent('content'); ?>
        <!-- /ძირითადი შიგთავსი -->
        
        <!-- საიტის ძირი -->
        <footer class="border-top">
            <div class="container px-4 px-lg-5">
                <div class="row gx-4 gx-lg-5 justify-content-center">
                    <div class="col-md-10 col-lg-8 col-xl-7">
                        <ul class="list-inline text-center">
                            <li class="list-inline-item">
                                <a href="tel:<?php echo e($contact->phone); ?>">
                                    <span class="fa-stack fa-lg">
                                        <i class="fas fa-circle fa-stack-2x"></i>
                                        <i class="fas fa-phone fa-stack-1x fa-inverse"></i>
                                    </span>
                                </a>
                            </li>
                            <li class="list-inline-item">
                                <a href="mailto:<?php echo e($contact->email); ?>">
                                    <span class="fa-stack fa-lg">
                                        <i class="fas fa-circle fa-stack-2x"></i>
                                        <i class="fas fa-envelope fa-stack-1x fa-inverse"></i>
                                    </span>
                                </a>
                            </li>
                        </ul>
                        <div class="small text-center text-muted fst-italic">Copyright © Your Website 2021</div>
                    </div>
                </div>
            </div>
        </footer>
        <!-- საიტის ძირი -->
        
        <!-- Bootstrap core JS-->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.bundle.min.js"></script>
        <!-- Core theme JS-->
        <script src="<?php echo e(asset('assets/front/js/scripts.js')); ?>"></script>
        
    </body>
</html>
                
<?php /**PATH C:\xampp\htdocs\projects\blog\resources\views/front/layout.blade.php ENDPATH**/ ?>