
<?php $__env->startSection('title','სიახლეები'); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h1 class="mt-4">სიახლეები</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('articles.create')); ?>" class="btn btn-sm btn-success">დამატება</a>
        </li>
    </ol>
    <div class="row">
        
        <?php if(Session::has('result')): ?>
        <div class="col-md-12">
            <div class="alert alert-<?php echo e(Session::get('result') ? 'success' : 'danger'); ?>">
                ოპერაცია <?php echo e(Session::get('result') ? 'წარმატებით' : 'წარუმატებლად'); ?> დასრულდა
            </div>
        </div>
        <?php endif; ?>
        
        <div class="col-md-12">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">სათაური</th>
                        <th scope="col">ფოტო</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th scope="row"><?php echo e(++$key); ?></th>
                            <td><?php echo e($item->title); ?></td>
                            <td>
                                <img src="<?php echo e($item->image); ?>" style="width: 50px; height: 50px;">                                
                            </td>
                            <td>
                                <a href="<?php echo e(route('articles.edit', $item->id)); ?>" class="btn btn-sm btn-primary" style="float: left; margin-right: 5px">
                                    <i class="fa fa-edit"></i> 
                                </a>
                                <form action="<?php echo e(route('articles.destroy', $item->id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="_method" value="delete">
                                    <a href="#!" class="btn btn-sm btn-danger btn-destroy">
                                        <i class="fa fa-trash"></i> 
                                    </a>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    
    $('.btn-destroy').on('click', function(){
        
        if(confirm('დარწმუნებული ხართ ?'))
        {
            $(this).parent('form').submit();         
        }
        
    });
    
</script>
<?php $__env->stopSection(); ?>

                
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\blog\resources\views/admin/articles/index.blade.php ENDPATH**/ ?>