<?php

namespace App\Models;

use Hash;
use Illuminate\Database\Eloquent\Model;

class Admin extends Model 
{
    protected $fillable = ['name','password'];
    
    public static function store($request) 
    {
        $item = new Admin();
        
        $item->name = $request->name;
        $item->email = $request->email;
        $item->password = Hash::make($request->password);

        return $item->save();         
    }
    
    public static function updateItem($request, $item)
    {
        if ($request->password) 
        {
            $update = $item->update([
                'name' => $request->name,
                'email' => $request->email,
                'password' => Hash::make($request->password)
            ]);
        } 
        else 
        {
            $update = $item->update([
                'name' => $request->name,
                'email' => $request->email
            ]);
        }
        
        return $update;           
    }
}
                

                