<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use DB;
use App;
use Auth;
use App\Models\Article;

class IndexController extends Controller
{
    public function index()
    {
        $articles = Article::all(App::getLocale());
        
        return view('front.index', compact('articles'));
    }
    
    public function article($id)
    {
        $article = Article::item(App::getLocale(), $id); 
        
        if(!$article)
        {
            return redirect()->back();
        }
        
        return view('front.article', compact('article'));
    }
}
