<?php

namespace App\Http\Controllers\Admin;

use Hash;
use App\Models\Admin;
use Illuminate\Http\Request;

class LoginController extends BaseController
{
    public function showLogin(Request $request) 
    {
        /* 
            თუ სესიაში უკვე შენახულია ავტორიზებული ადმინისტრატორის შესაბამისი 
            მოდელი გადავიდეთ მთავარ გვერდზე, წინააღმდეგ შემთხვევაში ჩავტვირთოთ
            ავტორიზაციის ფორმა (AdminMainPage მარშრუტს შევქმნით ოდნავ ქვემოთ)
        */

        return $request->session()->has('admin') ? redirect()->route('AdminMainPage') : view('admin.login');      
    }    

    public function login(Request $request)
    {
        // ვალიდაცია
    	$this->validate( $request , [
            'password' => 'required',
            'email' => 'required|email'
    	]);

        // ვიპოვოთ ადმინისტრატორი მითითებული ელ-ფოსტით
    	$admin = Admin::where('email', $request->email)->first();
        
        // თუ ადმინისტრატრორი ვერ მოიძებნა ან მოიძებნა, მაგრამ არ ემთხვევა პაროლი
    	if(!$admin || ($admin && !Hash::check($request->password, $admin->password)))
        {
            return redirect()->back()->with('login_failed', true);
    	}

        // შევინახოთ ადმინისტრატორის მოდელი სესიაში
    	$request->session()->put('admin' , $admin);
        
        return redirect()->route('AdminMainPage');       
    }
    
    public function logout(Request $request) 
    {
        $request->session()->forget('admin');

        return redirect()->route('ShowLogin');
    }                
}
                
                