<?php

namespace App\Http\Controllers\Admin;

use DB;
use Cache;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ContactsController extends Controller
{
    public function edit($id)
    {
        $item = DB::table('contacts')->first();
        
        return view('admin.contact.edit', compact('item'));
    }
    
    public function update(Request $request, $id)
    {
        // ვალიდაცია
        $this->validate($request, [
            'phone' => 'required|string|max:255',
            'email' => 'required|email|max:255'
        ]);
        
        $update = $update = DB::table('contacts')->where('id',$id)->update([
            'phone' => $request->phone,
            'email' => $request->email
        ]);
        
        $request->session()->flash('result', true);
        
        return redirect()->back();  
    }
    
    public function cache(Request $request)
    {
        // თუ საკონტაქტო ინფორმაცია უკვე შენახულია ქეშში
        if(Cache::has('contacts'))
        {
            // წავშალოთ იგი
            Cache::forget('contacts');
        }
        else // თუ არადა 
        {
            // შევინახოთ 
            Cache::remember('contacts', 3600, function () {
                return DB::table('contacts')->first();
            });
        }
        
        $request->session()->flash('result', true);
        
        return redirect()->back();  
    }
}
                
                