<?php

namespace App\Http\Controllers\Admin;

use App\Models\Admin;
use Illuminate\Http\Request;

class AdminsController extends BaseController
{
    // ჩამონათვალის გვერდი
    public function index()
    {
        $items = Admin::all();
        return view('admin.admins.index', compact('items'));
    }

    // ადმინსტრატორის დამატების ფორმის გვერდი
    public function create()
    {
        return view('admin.admins.create');
    }

    // ადმინსტრატორის შენახვა მბ-ში
    public function store(Request $request)
    {
        // ვალიდაცია
        $this->validate($request, [
            'name' => 'required|string|max:255',
            'password' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:admins',
        ]);

        $store = Admin::store($request); // true ან false
        
        $request->session()->flash('result', $store);
        
        return redirect()->route('admins.index');
    }

    // ადმინსტრატორის რედაქტირების ფორმის გვერდი
    public function edit($id)
    {
        $item = Admin::findOrFail($id);
        
        return view('admin.admins.edit', compact('item'));
    }
    
    // ადმინსტრატორის განახლება მბ-ში
    public function update(Request $request, $id)
    {
        // ვალიდაცია
        $this->validate($request, [
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:admins,email,' . $id,
        ]);
        
        $item = Admin::findOrFail($id);
        $update = Admin::updateItem($request, $item); // true ან false
        $request->session()->flash('result', $update);
        
        return redirect()->back();      
    }

    // ადმინსტრატორის წაშლა მბ-ში
    public function destroy(Request $request, $id)
    {
        if($id == 1)
        {
            return redirect()->back();  
        }
        
        $delete = Admin::find($id)->delete();
        $request->session()->flash('result', $delete);
        
        return redirect()->back();      
    }
}             